<?php
namespace StInMaWi\Controller;

use PDOException;
use StInMaWi\Pages\PagesRepository;

/** @package StInMaWi\Controller */
abstract class AbstractController
{
    /**
     * @param PagesRepository $pagesRepository 
     * @return void 
     */
    public function __construct(protected PagesRepository $pagesRepository) { }

    /**
     * @return void 
     * @throws PDOException 
     */
    protected function showError404()
    {
        http_response_code(404);
        $this -> render("abstract/showError404", []);
    }

    protected function showAccessDenied401()
    {
        http_response_code(401);
        $this -> render("abstract/showAccessDenied401", []);
    }

    /**
     * @param mixed $path 
     * @param array $data 
     * @return void 
     * @throws PDOException 
     */
    protected function render($path, array $data = [])
    {
        ob_start();
        extract($data);
        require __DIR__ . '/../../views/frontend/' . $path . '.view.php';
        $content = ob_get_contents();
        ob_end_clean();

        $navigation = $this -> pagesRepository -> getNavigation();
        $posts = $this -> pagesRepository -> getPosts();

        require __DIR__ . '/../../views/frontend/layouts/main/main.view.php';
    }

    protected function renderAdmin($path, array $data = [])
    {
        ob_start();
        extract($data);
        require __DIR__ . '/../../views/admin/' . $path . '.view.php';
        $content = ob_get_contents();
        ob_end_clean();

        $navigation = $this -> pagesRepository -> getNavigation();
        
        require __DIR__ . '/../../views/admin/layouts/main.view.php';
    }

} 