<?php

namespace StInMaWi\Controller\Admin;

use PDOException;
use StInMaWi\Controller\AbstractController;

/** @package StInMaWi\Controller\Admin */
class AdminAPIController extends AbstractController
{
    /**
     * @return void 
     * @throws PDOException 
     */
    public function getAllPages()
    {
        $getAllPages = $this -> pagesRepository -> getAll();
        $this -> renderAdmin('api/getallpages', [
            'getallpages' => $getAllPages
        ]);
    }

    public function createPage()
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $title = @(string) ($_POST['pageTitle'] ?? '');
            $slug = @(string) ($_POST['pageSlug'] ?? '');
            $content = @(string) ($_POST['pageContent'] ?? '');

            if(empty($slug))
            {
                $preSlug = str_replace(' ', '-', $title);
                $slug = strtolower($preSlug);
            }

            if(!empty($title) && !empty($slug) && !empty($content))
            {
                $success = $this -> pagesRepository -> createPage($title, $slug, $content);
                if($success)
                {
                    header('Location: ./?route=admin/pages');
                    return;
                }
                else
                {
                    $errorMessage = 'Die Seite konnte nicht angelegt werden..., evtl. exisiert der Slug schon...';   
                }
            }
            else
            {
                $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...';
            }

            $this -> renderAdmin('pages/create-page', [
                'errorMessage' => $errorMessage
            ]);
        }
        else
        {
            $this -> renderAdmin('pages/create-page', []);
        }
    }

    /**
     * @param mixed $id 
     * @return void 
     * @throws PDOException 
     */
    public function editPage($id)
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $id = @(int) ($_POST['pageId'] ?? 0);
            $title = @(string) ($_POST['pageTitle'] ?? '');
            $content = @(string) ($_POST['pageContent'] ?? '');

            if(!empty($title) && !empty($content))
            {
                $this ->pagesRepository->updatePage($id, $title, $content);
                header('Location: ./?route=admin/pages');
                return;
            }
            
            $page = $this -> pagesRepository -> findById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page,
                'errorMessage' => $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...'
            ]);         
        }
        else
        {
            $page = $this -> pagesRepository -> findById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page
            ]);
        }
    }

    /**
     * @param mixed $id 
     * @return void 
     * @throws PDOException 
     */
    public function deletePage($id)
    {
        $pages = $this -> pagesRepository -> deletePage($id);
        header('Location: ./?route=admin/pages');
    }

    /**
     * @return void 
     * @throws PDOException 
     */
    public function comments()
    {
        $pages = $this -> pagesRepository -> getAll();
        $this -> renderAdmin('pages/comments', [
            'pages' => $pages
        ]);
    }

    /**
     * @return void 
     * @throws PDOException 
     */
    public function users()
    {
        $pages = $this -> pagesRepository -> getAll();
        $this -> renderAdmin('pages/users', [
            'pages' => $pages
        ]);
    }
}