<?php

namespace StInMaWi\Controller;

use StInMaWi\Pages\PagesRepository;

class PagesController extends AbstractController
{
    public function __construct(PagesRepository $pagesRepository)
    {
        parent::__construct($pagesRepository);
    }

    public function showPage(string $pageKey)
    {
        $page = $this -> pagesRepository -> getPage($pageKey);
        if(empty($page))
        {
            return $this -> showError404();
        }

        $this -> render('pages/showPage', [
            'page' => $page
        ]);
    }
}