<?php

namespace StInMaWi\Helper;

use PDO;
use PDOException;

class AuthService
{
    public function __construct(protected PDO $pdo) { }

    /** @return void  */
    protected function ensureSession()
    {
        if(session_status() === PHP_SESSION_NONE)
        {
            session_start();
        }
    }

    public function ensureLoggedIn()
    {
        $this -> ensureSession();
        if(isset($_SESSION['loginUser']) && $_SESSION['loginType'])
        {
            $username = (string) $_SESSION['loginUser'];

            $stmt = $this -> pdo -> prepare('SELECT `id`, `username`, `password`, `email`, `type` FROM `users` WHERE `username` = :userName');
            $stmt -> bindValue(':userName', $username);
            $stmt -> setFetchMode(PDO::FETCH_CLASS, AuthServiceUser::class);
            $stmt -> execute();
            $user = $stmt -> fetch();

            if(!empty($user))
            {
                return;
            }
        }

        header('Location: /?route=admin/login');
        die();
    }

    /**
     * @param string $username 
     * @param string $password 
     * @return bool 
     * @throws PDOException 
     */
    public function handleLogin(string $username, string $password): bool
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `username`, `password`, `email`, `type`, `key_2fa` FROM `users` WHERE `username` = :userName');
        $stmt -> bindValue(':userName', $username);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, AuthServiceUser::class);
        $stmt -> execute();
        $user = $stmt -> fetch();

        $passwordOk = password_verify($password, $user -> password);
        $userType = $user -> type;

        if($passwordOk === true)
        {
            $this -> ensureSession();
            session_regenerate_id();
            $_SESSION['loginUser'] = $username;
            $_SESSION['loginType'] = $userType;
            $_SESSION['loginIPv4_6'] = $_SERVER['REMOTE_ADDR'];
            return true;
        }
        else
        {
            return false;
        }
    }

    public function logout()
    {
        $this -> ensureSession();
        unset($_SESSION['loginUser']);
        unset($_SESSION['loginType']);
        unset($_SESSION['loginIPv4_6']);
    }
}