<?php

namespace StInMaWi\Media;

use PDO;
use StInMaWi\Media\MediaModel;

/** @package StInMaWi\Media */
class MediaRepository
{
    /**
     * @param PDO $pdo 
     * @return void 
     */
    public function __construct(protected PDO $pdo) { }

    public function getNavigation(): array
    {
        return $this -> getAllMedias();
    }

    public function getAllMedias(): array
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `slug`, `title`, `content` FROM `pages` ORDER BY `id` ASC');
        $stmt -> execute();
        return $stmt -> fetchAll(PDO::FETCH_CLASS, MediaModel::class);
    }

    public function getPage(string $slug): ?MediaModel
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `slug`, `title`, `content` FROM `pages` WHERE `slug` = :slug');
        $stmt -> bindValue(':slug', $slug);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, MediaModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }

    public function findPageById(int $id): ?MediaModel
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `slug`, `title`, `content` FROM `pages` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, MediaModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }
    
    public function createPage(string $title, string $slug, string $content): bool
    {
        $existsStmt = $this -> pdo -> prepare('SELECT COUNT(*) AS c FROM `pages` WHERE `slug` = :slug');
        $existsStmt -> bindValue(':slug', $slug);
        $existsStmt -> setFetchMode(PDO::FETCH_ASSOC);
        $existsStmt -> execute();
        $existsValue = $existsStmt -> fetch();
        if (empty($existsValue) || $existsValue['c'] != 0) {
            return false;
        }

        $stmt = $this -> pdo -> prepare('INSERT INTO `pages` (title, slug, content) VALUES (:title, :slug, :content)');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':slug', $slug);
        $stmt -> bindValue(':content', $content);
        $stmt -> execute();

        return true;
    }

    public function updatePage(int $id, string $title, string $content)
    {
        $stmt = $this -> pdo -> prepare('UPDATE `pages` SET `title` = :title, `content` = :content WHERE `id` = :id ');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':content', $content);
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function deletePage($id)
    {
        $stmt = $this -> pdo -> prepare('DELETE FROM `pages` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }
}