<?php

namespace StInMaWi\Pages;

use DateTime;
use PDO;
use PDOException;
use StInMaWi\Posts\PostsModel;
use StInMaWi\Media\MediaModel;
use StInMaWi\Posts\ExtensionsModel;
use StInMaWi\Settings\SettingsModel;
use StInMaWi\Users\UsersModel;

/** @package StInMaWi\Pages */
class PagesRepository
{
    /**
     * @param PDO $pdo 
     * @return void 
     */
    public function __construct(protected PDO $pdo) { }

    public function getNavigation(): array
    {
        return $this -> getAllPages();
    }

    public function getTopNavigation(): array
    {
        return $this -> getAllPages();
    }

    public function getAllMedias(): array
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `slug`, `title`, `content` FROM `pages` ORDER BY `id` ASC');
        $stmt -> execute();
        return $stmt -> fetchAll(PDO::FETCH_CLASS, MediaModel::class);
    }

    public function getMedia(string $slug): ?MediaModel
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `slug`, `title`, `content` FROM `pages` WHERE `slug` = :slug');
        $stmt -> bindValue(':slug', $slug);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, MediaModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }

    public function findMediaById(int $id): ?MediaModel
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `slug`, `title`, `content` FROM `pages` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, MediaModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }
    
    public function createMedia(string $title, string $slug, string $content): bool
    {
        $existsStmt = $this -> pdo -> prepare('SELECT COUNT(*) AS c FROM `pages` WHERE `slug` = :slug');
        $existsStmt -> bindValue(':slug', $slug);
        $existsStmt -> setFetchMode(PDO::FETCH_ASSOC);
        $existsStmt -> execute();
        $existsValue = $existsStmt -> fetch();
        if (empty($existsValue) || $existsValue['c'] != 0) {
            return false;
        }

        $stmt = $this -> pdo -> prepare('INSERT INTO `pages` (title, slug, content) VALUES (:title, :slug, :content)');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':slug', $slug);
        $stmt -> bindValue(':content', $content);
        $stmt -> execute();

        return true;
    }

    public function updateMedia(int $id, string $title, string $content)
    {
        $stmt = $this -> pdo -> prepare('UPDATE `pages` SET `title` = :title, `content` = :content WHERE `id` = :id ');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':content', $content);
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function deleteMedia($id)
    {
        $stmt = $this -> pdo -> prepare('DELETE FROM `pages` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function getAllPages(): array
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `slug`, `title`, `content` FROM `pages` ORDER BY `id` ASC');
        $stmt -> execute();
        return $stmt -> fetchAll(PDO::FETCH_CLASS, PagesModel::class);
    }

    public function getPage(string $slug): ?PagesModel
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `slug`, `title`, `content` FROM `pages` WHERE `slug` = :slug');
        $stmt -> bindValue(':slug', $slug);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, PagesModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }

    public function findPageById(int $id): ?PagesModel
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `slug`, `title`, `content` FROM `pages` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, PagesModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }
    
    public function createPage(string $title, string $slug, string $content): bool
    {
        $existsStmt = $this -> pdo -> prepare('SELECT COUNT(*) AS c FROM `pages` WHERE `slug` = :slug');
        $existsStmt -> bindValue(':slug', $slug);
        $existsStmt -> setFetchMode(PDO::FETCH_ASSOC);
        $existsStmt -> execute();
        $existsValue = $existsStmt -> fetch();
        if (empty($existsValue) || $existsValue['c'] != 0) {
            return false;
        }

        $stmt = $this -> pdo -> prepare('INSERT INTO `pages` (title, slug, content) VALUES (:title, :slug, :content)');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':slug', $slug);
        $stmt -> bindValue(':content', $content);
        $stmt -> execute();

        return true;
    }

    public function updatePage(int $id, string $title, string $content)
    {
        $stmt = $this -> pdo -> prepare('UPDATE `pages` SET `title` = :title, `content` = :content WHERE `id` = :id ');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':content', $content);
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function deletePage($id)
    {
        $stmt = $this -> pdo -> prepare('DELETE FROM `pages` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function getShopPage()
    {

    }

    public function getAllGeneral(): array
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `title`, `subtitle`, `site_title`, `is_blog`, `is_register`, `is_admin_mail`, `is_header`, `is_header_nav`, `is_footer`, `is_footer_nav`
        , `is_primary`, `is_accent`, `is_use_email`, `is_cookie_banner` FROM `settings` ORDER BY `id` ASC');
        $stmt -> execute();
        return $stmt -> fetchAll(PDO::FETCH_CLASS, SettingsModel::class);
    }

    public function findSettingsById(int $id): ?SettingsModel
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `title`, `subtitle`, `site_title`, `is_blog`, `is_register`, `is_admin_mail`, `is_header`, `is_header_nav`, `is_footer`, `is_footer_nav`
        , `is_primary`, `is_accent`, `is_use_email`, `is_cookie_banner` FROM `settings` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, SettingsModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }
    
    public function createGeneral(string $title, string $subtitle, string $sitetitle, bool $is_blog, bool $is_register, string $is_admin_mail, bool $is_use_email, bool $is_cookie_banner): bool
    {
        $stmt = $this -> pdo -> prepare('INSERT INTO `settings` (title, subtitle, site_title, is_blog, is_register, is_admin_mail, is_use_email
        , is_cookie_banner) VALUES (:title, :subtitle, :sitetitle, :is_blog, :is_register, :is_admin_mail, :is_use_email, :is_cookie_banner)');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':subtitle', $subtitle);
        $stmt -> bindValue(':sitetitle', $sitetitle);
        $stmt -> bindValue(':is_blog', $is_blog);
        $stmt -> bindValue(':is_register', $is_register);
        $stmt -> bindValue(':is_admin_mail', $is_admin_mail);
        $stmt -> bindValue(':is_use_email', $is_use_email);
        $stmt -> bindValue(':is_cookie_banner', $is_cookie_banner);
        $stmt -> execute();

        return true;
    }

    public function updateGeneral(int $id, string $title, string $subtitle, string $sitetitle, bool $is_blog, bool $is_register, string $is_admin_mail, bool $is_use_email, bool $is_cookie_banner)
    {
        $stmt = $this -> pdo -> prepare('UPDATE `settings` SET title = :title, subtitle = :subtitle, site_title = :sitetitle, is_blog = :is_blog, is_register = :is_register
        , is_admin_mail = :is_admin_mail, is_use_email = :is_use_email, is_cookie_banner = :is_cookie_banner WHERE `id` = :id ');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':subtitle', $subtitle);
        $stmt -> bindValue(':sitetitle', $sitetitle);
        $stmt -> bindValue(':is_blog', $is_blog);
        $stmt -> bindValue(':is_register', $is_register);
        $stmt -> bindValue(':is_admin_mail', $is_admin_mail);
        $stmt -> bindValue(':is_use_email', $is_use_email);
        $stmt -> bindValue(':is_cookie_banner', $is_cookie_banner);
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function findDesignById(int $id): ?SettingsModel // TODO:
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `title`, `subtitle`, `site_title`, `is_blog`, `is_register`, `is_admin_mail`, `is_header`, `is_header_nav`, `is_footer`, `is_footer_nav`
        , `is_primary`, `is_accent`, `is_use_email`, `is_cookie_banner` FROM `settings` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, SettingsModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }

    public function createDesign(string $is_header, string $is_header_nav, string $is_footer, string $is_footer_nav, string $is_primary, string $is_accent): bool
    {
        $stmt = $this -> pdo -> prepare('INSERT INTO `settings` (is_header, is_header_nav, is_footer, is_footer_nav, is_primary, is_accent) VALUES (:is_header, :is_header_nav, :is_footer, :is_footer_nav, :is_primary, :is_accent)');

        $stmt -> bindValue(':is_header', $is_header);
        $stmt -> bindValue(':is_header_nav', $is_header_nav);
        $stmt -> bindValue(':is_footer', $is_footer);
        $stmt -> bindValue(':is_footer_nav', $is_footer_nav);
        $stmt -> bindValue(':is_primary', $is_primary);
        $stmt -> bindValue(':is_accent', $is_accent);
        $stmt -> execute();

        return true;
    }

    public function updateDesign(int $id, string $is_header, string $is_header_nav
    , string $is_footer, string $is_footer_nav, string $is_primary, string $is_accent)
    {
        $stmt = $this -> pdo -> prepare('UPDATE `settings` SET is_header = :is_header, is_header_nav = :is_header_nav, is_footer = :is_footer
        , is_footer_nav = :is_footer_nav, is_primary = :is_primary, is_accent = :is_accent WHERE `id` = :id ');
        $stmt -> bindValue(':is_header', $is_header);
        $stmt -> bindValue(':is_header_nav', $is_header_nav);
        $stmt -> bindValue(':is_footer', $is_footer);
        $stmt -> bindValue(':is_footer_nav', $is_footer_nav);
        $stmt -> bindValue(':is_primary', $is_primary);
        $stmt -> bindValue(':is_accent', $is_accent);
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function findMenuById(int $id): ?SettingsModel // TODO:
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `title`, `subtitle`, `site_title`, `is_blog`, `is_register`, `is_admin_mail`, `is_header`, `is_header_nav`, `is_footer`, `is_footer_nav`
        , `is_primary`, `is_accent`, `is_use_email`, `is_cookie_banner` FROM `settings` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, SettingsModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }

    public function getAllPosts(): array
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `slug`, `title`, `content` FROM `posts` ORDER BY `id` ASC');
        $stmt -> execute();
        return $stmt -> fetchAll(PDO::FETCH_CLASS, PostsModel::class);
    }

    public function getPosts(): array
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `slug`, `title`, `content` FROM `posts` ORDER BY `id` ASC');
        $stmt -> execute();
        return $stmt -> fetchAll(PDO::FETCH_CLASS, PostsModel::class);
    }

    public function getPost(string $slug): ?PostsModel
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `slug`, `title`, `content` FROM `posts` WHERE `slug` = :slug');
        $stmt -> bindValue(':slug', $slug);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, PostsModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }

    public function findPostById(int $id): ?PostsModel
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `slug`, `title`, `content` FROM `posts` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, PostsModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }
    
    public function createPost(string $title, string $slug, string $content): bool
    {
        $existsStmt = $this -> pdo -> prepare('SELECT COUNT(*) AS c FROM `posts` WHERE `slug` = :slug');
        $existsStmt -> bindValue(':slug', $slug);
        $existsStmt -> setFetchMode(PDO::FETCH_ASSOC);
        $existsStmt -> execute();
        $existsValue = $existsStmt -> fetch();
        if (empty($existsValue) || $existsValue['c'] != 0) {
            return false;
        }

        $stmt = $this -> pdo -> prepare('INSERT INTO `posts` (title, slug, content) VALUES (:title, :slug, :content)');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':slug', $slug);
        $stmt -> bindValue(':content', $content);
        $stmt -> execute();

        return true;
    }

    public function updatePost(int $id, string $title, string $content)
    {
        $stmt = $this -> pdo -> prepare('UPDATE `posts` SET `title` = :title, `content` = :content WHERE `id` = :id ');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':content', $content);
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function deletePost($id)
    {
        $stmt = $this -> pdo -> prepare('DELETE FROM `posts` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function getUsers(): array
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `username`, `password`, `email`, `type` FROM `users` ORDER BY `id` ASC');
        $stmt -> execute();
        return $stmt -> fetchAll(PDO::FETCH_CLASS, UsersModel::class);
    }

    public function findUserById(int $id): ?UsersModel
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `username`, `password`, `email`, `type` FROM `users` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, UsersModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }

    public function createUser(string $username, string $password, string $email, string $type, string $addedDate, string $addedBy): bool
    {
        $existsStmt = $this -> pdo -> prepare('SELECT COUNT(*) AS c FROM `users` WHERE `username` = :username');
        $existsStmt -> bindValue(':username', $username);
        $existsStmt -> setFetchMode(PDO::FETCH_ASSOC);
        $existsStmt -> execute();
        $existsValue = $existsStmt -> fetch();
        if (empty($existsValue) || $existsValue['c'] != 0) {
            return false;
        }

        $stmt = $this -> pdo -> prepare('INSERT INTO `users` (username, password, email, type, added_date, added_by) VALUES (:username, :password, :email, :type, :added_date, :added_by)');
        $stmt -> bindValue(':username', $username);
        $stmt -> bindValue(':password', $password);
        $stmt -> bindValue(':email', $email);
        $stmt -> bindValue(':type', $type);
        $stmt -> bindValue(':added_date', $addedDate);
        $stmt -> bindValue(':added_by', $addedBy);
        $stmt -> execute();

        return true;
    }

    public function updateUser(int $id, string $username, string $password, string $email, string $type, string $modifiedDate, string $modifiedBy)
    {
        $stmt = $this -> pdo -> prepare('UPDATE `users` SET `username` = :username, `password` = :password, `email` = :email, `type` = :type `modified_date` = :modifiedDate, modified_by = :modifiedBy WHERE `id` = :id ');
        $stmt -> bindValue(':username', $username);
        $stmt -> bindValue(':password', $password);
        $stmt -> bindValue(':email', $email);
        $stmt -> bindValue(':type', $type);
        $stmt -> bindValue(':modifiedDate', $modifiedDate);
        $stmt -> bindValue(':modifiedBy', $modifiedBy);
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function deleteUser($id)
    {
        $stmt = $this -> pdo -> prepare('DELETE FROM `users` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }

    public function findShopById(int $id): ?SettingsModel // TODO:
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `title`, `subtitle`, `site_title`, `is_blog`, `is_register`, `is_admin_mail`, `is_header`, `is_header_nav`, `is_footer`, `is_footer_nav`
        , `is_primary`, `is_accent`, `is_use_email`, `is_cookie_banner` FROM `settings` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, SettingsModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }

    public function getAllExtensions(): array
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `title`, `decription`, `version_number`, `added_date`, `added_by` FROM `extensions` ORDER BY `id` ASC');
        $stmt -> execute();
        return $stmt -> fetchAll(PDO::FETCH_CLASS, ExtensionsModel::class);
    }
}