<?php

namespace StInMaWi\Settings;

use PDO;
use PDOException;
use StInMaWi\Settings\SettingsModel;

/** @package StInMaWi\Settings */
class PagesRepository
{
    /**
     * @param PDO $pdo 
     * @return void 
     */
    public function __construct(protected PDO $pdo) { }

    public function getAllSettings(): array
    {
        $stmt = $this -> pdo -> prepare('SELECT `id`, `title`, `subtitle`, `is_blog`, `is_register`, `is_admin_mail`, `is_header`, `is_header_nav`, `is_footer`, `is_footer_nav`
        , `is_primary`, `is_accent`, `is_use_email` FROM `settings` ORDER BY `id` ASC');
        $stmt -> execute();
        return $stmt -> fetchAll(PDO::FETCH_CLASS, SettingsModel::class);
    }

    public function findById(int $id): ?SettingsModel
    {
        $stmt = $this->pdo->prepare('SELECT `id`, `title`, `subtitle`, `is_blog`, `is_register`, `is_admin_mail`, `is_header`, `is_header_nav`, `is_footer`, `is_footer_nav`
        , `is_primary`, `is_accent`, `is_use_email` FROM `settings` WHERE `id` = :id');
        $stmt -> bindValue(':id', $id);
        $stmt -> setFetchMode(PDO::FETCH_CLASS, SettingsModel::class);
        $stmt -> execute();
        $entry = $stmt -> fetch();

        if(!empty($entry))
        {
            return $entry;
        }
        else
        {
            return null;
        }
    }
    
    public function createSetting(string $title, string $subtitle, bool $is_blog, bool $is_register, string $is_admin_mail, string $is_header, string $is_header_nav
    , string $is_footer, string $is_footer_nav, string $is_primary, string $is_accent, bool $is_use_email): bool
    {
        $stmt = $this -> pdo -> prepare('INSERT INTO `settings` (title, subtitle, is_blog, is_register, is_admin_mail, is_header, is_header_nav, is_footer, is_footer_nav
        , is_primary, is_accent, is_use_email) VALUES (:title, :subtitle, :is_blog, :is_register, :is_admin_mail, :is_header, :is_header_nav, :is_footer, :is_footer_nav
        , :is_primary, :is_accent, :is_use_email)');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':subtitle', $subtitle);
        $stmt -> bindValue(':is_blog', $is_blog);
        $stmt -> bindValue(':is_register', $is_register);
        $stmt -> bindValue(':is_admin_mail', $is_admin_mail);
        $stmt -> bindValue(':is_header', $is_header);
        $stmt -> bindValue(':is_header_nav', $is_header_nav);
        $stmt -> bindValue(':is_footer', $is_footer);
        $stmt -> bindValue(':is_footer_nav', $is_footer_nav);
        $stmt -> bindValue(':is_primary', $is_primary);
        $stmt -> bindValue(':is_accent', $is_accent);
        $stmt -> bindValue(':is_use_email', $is_use_email);
        $stmt -> execute();

        return true;
    }

    public function updateSetting(int $id, string $title, string $subtitle, bool $is_blog, bool $is_register, string $is_admin_mail, string $is_header, string $is_header_nav
    , string $is_footer, string $is_footer_nav, string $is_primary, string $is_accent, bool $is_use_email)
    {
        $stmt = $this -> pdo -> prepare('UPDATE `settings` SET `title` = :title, `subtitle` = :subtitle, is_blog = :is_blog, is_register = :is_register
        , is_admin_mail = :is_admin_mail, is_header = :is_header, is_header_nav = :is_header_nav, is_footer = :is_footer, is_footer_nav = :is_footer_nav, is_primary = :is_primary
        , is_accent = :is_accent, is_use_email = :is_use_email WHERE `id` = :id ');
        $stmt -> bindValue(':title', $title);
        $stmt -> bindValue(':subtitle', $subtitle);
        $stmt -> bindValue(':is_blog', $is_blog);
        $stmt -> bindValue(':is_register', $is_register);
        $stmt -> bindValue(':is_admin_mail', $is_admin_mail);
        $stmt -> bindValue(':is_header', $is_header);
        $stmt -> bindValue(':is_header_nav', $is_header_nav);
        $stmt -> bindValue(':is_footer', $is_footer);
        $stmt -> bindValue(':is_footer_nav', $is_footer_nav);
        $stmt -> bindValue(':is_primary', $is_primary);
        $stmt -> bindValue(':is_accent', $is_accent);
        $stmt -> bindValue(':is_use_email', $is_use_email);
        $stmt -> bindValue(':id', $id);
        $stmt -> execute();
    }
}