<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0"><?php echo gettext("Create page") ?></h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#"><?php echo gettext("Administrator") ?></a></li>
            <li class="breadcrumb-item active"><?php echo gettext("Create page") ?></li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
  <!-- /.content-header -->

  <!-- Main content -->
  <div class="content">
    <div class="container-fluid bg-white py-3">
      <?php if(!empty($errorMessage)): ?>
      <div class="row">
          <div class="col">
              <p><?php echo bulletProof($errorMessage) ?></p>
          </div>
      </div>
      <?php endif; ?>

      <div class="row">
        <div class="col">
          <form action="./?route=admin/pages/create-page" method="POST">
            <input type="hidden" id="csrf_token" name="csrf_token" value="<?php echo csrf_token(); ?>"  />
            <input hidden type="number" id="id" name="id" />
            <div class="row mb-1">
              <div class="col">
                <div class="form-floating mb-1">
                  <input type="text" class="form-control" id="title" name="title" placeholder="Title" value="<?php if(!empty($_POST['title'])) echo $_POST['title'] ?>" />
                  <label for="title"><?php echo gettext("Title") ?></label>
                </div>
              </div>
            </div>

            <div class="row mb-1">
              <div class="col">
                <div class="form-floating mb-1">
                  <input type="text" class="form-control" id="slug" name="slug" placeholder="Slug" value="<?php if(!empty($_POST['slug'])) echo $_POST['slug']  ?>" />
                  <label for="slug"><?php echo gettext("Slug") ?></label>
                </div>
              </div>
            </div>

            <div class="row mb-1">
              <div class="col">
                <textarea class="form-control" id="content" name="content"><?php if(!empty($_POST['content'])) echo $_POST['content']; ?></textarea>
              </div>
            </div>

            <div class="row mb-1">
              <div class="col">
                <input type="submit" class="btn btn-sm btn-secondary" value="<?php echo gettext("Publish") ?>" />
                <input type="reset" class="btn btn-sm btn-secondary" value="<?php echo gettext("Cancel") ?>" />
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
  <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<!-- Control Sidebar -->
<aside class="control-sidebar control-sidebar-dark">
  <!-- Control sidebar content goes here -->
  <div class="p-3">
    <h5>Platzhalter-Title</h5>
    <p>Platzhalter-Sidebar content</p>
  </div>
</aside>
<!-- /.control-sidebar -->