<?php

use \StInMaWi\Controller\Admin\AdminPagesController;
use \StInMaWi\Controller\Admin\AdminMediaController;
use \StInMaWi\Controller\Admin\AdminUsersController;
use \StInMaWi\Controller\Admin\AdminSettingsController;
use \StInMaWi\Controller\Admin\AdminPostsController;
use \StInMaWi\Controller\Admin\AdminExtensionsController;
use \StInMaWi\Controller\Admin\LoginController;
use \StInMaWi\Controller\NotFoundController;
use \StInMaWi\Controller\PagesController;
use \StInMaWi\Media\MediaRepository;
use \StInMaWi\Pages\PagesRepository;
use \StInMaWi\Helper\Container;
use \StInMaWi\Helper\AuthService;
use \StInMaWi\Helper\CSRFHelper;

require_once __DIR__ . '/includes/includes.php';

$container = new Container();
$container -> add('pdo', function()
{
    return require __DIR__ . '/includes/db-connect.inc.php';
});
$container -> add('pagesRepository', function()use($container)
{
    return new PagesRepository($container -> get('pdo'));
});
$container -> add('pagesController', function()use($container)
{
    return new PagesController(
        $container -> get('pagesRepository')
    );
});
$container -> add('adminMediaController', function()use($container)
{
    return new AdminMediaController(
        $container -> get('pagesRepository')
    );
});
$container -> add('adminPagesController', function()use($container)
{
    return new AdminPagesController(
        $container -> get('pagesRepository')
    );
});
$container -> add('adminSettingsController', function()use($container)
{
    return new AdminSettingsController(
        $container -> get('pagesRepository')
    );
});
$container -> add('adminUsersController', function()use($container)
{
    return new AdminUsersController(
        $container -> get('pagesRepository')
    );
});
$container -> add('adminPostsController', function()use($container)
{
    return new AdminPostsController(
        $container -> get('pagesRepository')
    );
});
$container -> add('adminExtensionsController', function()use($container)
{
    return new AdminExtensionsController(
        $container -> get('pagesRepository')
    );
});
$container -> add('notFoundController', function()use($container)
{
    return new NotFoundController(
        $container -> get('pagesRepository')
    );
});
$container -> add('loginController', function() use($container)
{
    return new LoginController(
        $container -> get('pagesRepository'),
        $container -> get('authService')
    );
});
$container -> add('authService', function() use($container)
{
    return new AuthService(
        $container -> get('pdo')
    );
});
$container -> add('csrfHelper', function()
{
    return new CSRFHelper();
});

$csrfHelper = $container -> get('csrfHelper');
$csrfHelper -> handle();

/**
 * Move Functions???
 * @return mixed 
 */
function csrf_token()
{
    if(session_status() === PHP_SESSION_NONE)
    {
        session_start();
    }
    global $container;
    $csrfHelper = $container -> get('csrfHelper');
    return $csrfHelper -> generateCSRFToken();
}

$route = @(string) ($_GET['route'] ?? 'page');

if($route === 'install')
{
    firstStart();
}
else if($route === 'start-user')
{
    firstStartUser();
}
else if($route === 'start-webinfo')
{
    firstStartWebInfo();
}
else if($route === 'page')
{
    $pagesController = $container -> get('pagesController');
    $page = @(string) ($_GET['page'] ?? 'index');
    $pagesController -> showPage($page);
}
else if($route === 'page=blog')
{
    $pagesController = $container -> get('pagesController');
    $pagesController -> showPage($page);
    $postsController = $container -> get('postsController');
    $postsController -> posts($posts);
}
else if($route === 'admin/login')
{
    $loginController = $container -> get('loginController');
    $loginController -> login();
}
else if($route === 'admin/logout')
{
    $loginController = $container -> get('loginController');
    $loginController -> logout();
}
else if($route === 'admin/index')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminPagesController = $container -> get('adminPagesController');
    $adminPagesController -> index();
}
else if($route === 'admin/posts')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminPostsController = $container -> get('adminPostsController');
    $adminPostsController -> posts();
}
else if($route === 'admin/posts/create-post')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminPostsController = $container -> get('adminPostsController');
    $adminPostsController -> createPost();
}
else if($route === 'admin/media')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminMediaController = $container -> get('adminMediaController');
    $adminMediaController -> media();
}
else if($route === 'admin/pages')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminPagesController = $container -> get('adminPagesController');
    $adminPagesController -> pages();
}
else if($route === 'admin/pages/create-page')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminPagesController = $container -> get('adminPagesController');
    $adminPagesController -> createPage();
}
else if($route === 'admin/pages/edit-page')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminPagesController = $container -> get('adminPagesController');
    $id = @(int) ($_GET['id'] ?? 0);
    $adminPagesController -> editPage($id);
}
else if($route === 'admin/pages/delete-page')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminPagesController = $container -> get('adminPagesController');
    $id = @(int) ($_POST['pageId'] ?? 0);
    $adminPagesController -> deletePage($id);
}
else if($route === 'admin/comments')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminPagesController = $container -> get('adminPagesController');
    $adminPagesController -> comments();
}
else if($route === 'admin/users')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminUsersController = $container -> get('adminUsersController');
    $adminUsersController -> users();
}
else if($route === 'admin/create-user')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminUsersController = $container -> get('adminUsersController');
    $adminUsersController -> createUser();
}
else if($route === 'admin/edit-user')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminUsersController = $container -> get('adminUsersController');
    $id = @(int) ($_GET['id'] ?? 0);
    $adminUsersController -> editUser($id);
}
else if($route === 'admin/delete-user')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminUsersController = $container -> get('adminUsersController');
    $id = @(int) ($_POST['id'] ?? 0);
    $adminUsersController -> deleteUser($id);
}
else if($route === 'admin/settings/general')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminSettingsController = $container -> get('adminSettingsController');
    $adminSettingsController -> general();
}
else if($route === 'admin/settings/design')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminSettingsController = $container -> get('adminSettingsController');
    $adminSettingsController -> design();
}
else if($route === 'admin/settings/menu')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminSettingsController = $container -> get('adminSettingsController');
    $adminSettingsController -> menu();
}
else if($route === 'admin/settings/text-modules')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminPagesController = $container -> get('adminPagesController');
    $adminPagesController -> users();
}
else if($route === 'admin/settings/extensions')
{
    $authService = $container -> get('authService');
    $authService -> ensureLoggedIn();

    $adminSettingsController = $container -> get('adminSettingsController');
    $adminSettingsController -> extensions();
}
else
{
    $notFoundController = $container -> get('notFoundController');
    $notFoundController -> error404();
}