<?php

namespace StInMaWi\Controller\Admin;

use StInMaWi\Controller\AbstractController;

/** @package StInMaWi\Controller\Admin */
class AdminMediaController extends AbstractController
{
    public function media()
    {
        $medias = $this -> pagesRepository -> getAllMedias();
        $this -> renderAdmin('media/medias', [
            'medias' => $medias
        ]);
    }

    public function createMedia()
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $title = @(string) ($_POST['pageTitle'] ?? '');
            $slug = @(string) ($_POST['pageSlug'] ?? '');
            $content = @(string) ($_POST['pageContent'] ?? '');

            if(empty($slug))
            {
                $preSlug = str_replace(' ', '-', $title);
                $slug = strtolower($preSlug);
            }

            if(!empty($title) && !empty($slug) && !empty($content))
            {
                $success = $this ->pagesRepository ->createMedia($title, $slug, $content);
                if($success)
                {
                    header('Location: ./?route=admin/medias');
                    return;
                }
                else
                {
                    $errorMessage = 'Die Seite konnte nicht angelegt werden..., evtl. exisiert der Slug schon...';   
                }
            }
            else
            {
                $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...';
            }

            $this -> renderAdmin('media/create-media', [
                'errorMessage' => $errorMessage
            ]);
        }
        else
        {
            $this -> renderAdmin('media/create-media', []);
            $this -> renderAdmin('media/create-media', []);
        }
    }

    public function editMedia($id)
    {
        if(!empty($_POST))
        {
            $errorMessage = null;
            $id = @(int) ($_POST['pageId'] ?? 0);
            $title = @(string) ($_POST['pageTitle'] ?? '');
            $content = @(string) ($_POST['pageContent'] ?? '');

            if(!empty($title) && !empty($content))
            {
                $this ->pagesRepository->updatePage($id, $title, $content);
                header('Location: ./?route=admin/pages');
                return;
            }
            
            $page = $this -> pagesRepository -> findMediaById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page,
                'errorMessage' => $errorMessage = 'Es wurden nicht alle Felder vollständig ausgefüllt...'
            ]);         
        }
        else
        {
            $page = $this -> pagesRepository -> findMediaById($id);
            $this -> renderAdmin('pages/edit-page', [
                'page' => $page
            ]);
        }
    }

    public function deleteMedia($id)
    {
        $pages = $this -> pagesRepository -> deletePage($id);
        header('Location: ./?route=admin/pages');
    }
}