<?php

namespace StInMaWi\Controller\Admin;

use StInMaWi\Controller\AbstractController;
use StInMaWi\Pages\PagesRepository;
use StInMaWi\Helper\AuthService;

class LoginController extends AbstractController
{
    public function __construct(PagesRepository $pagesRepository, protected AuthService $authService)
    {
        parent::__construct($pagesRepository);
    }
    
    public function login()
    {
        if(!empty($_POST))
        {
            $username = @(string) ($_POST['userName'] ?? '');
            $password = @(string) ($_POST['userPassword'] ?? '');

            if(!empty($username) && !empty($password))
            {
                $loginOk = $this -> authService -> handleLogin($username, $password);
                if($loginOk)
                {
                    header('Location: ./?route=admin/index');
                    return;
                }
            }
            else
            {
                header('Location: ./?route=admin/login');
                return;
            }
        }
        else
        {
            $navigation = $this -> pagesRepository -> getNavigation();
            $this -> renderAdmin('login/login', [
                'navigation' => $navigation
            ]);
        }
    }

    public function logout()
    {
        $this -> authService -> logout();
        header('Location: /?route=admin/login');
    }
}