<?php

namespace StInMaWi\Helper;

use Exception;

/** @package StInMaWi\Helper */
class CSRFHelper
{
    /** @return void  */
    public function handle()
    {
        if($_SERVER['REQUEST_METHOD'] === 'POST')
        {
            if(session_status() === PHP_SESSION_NONE)
            {
                session_start();
            }

            if(isset($_POST['csrf_token']) && isset($_SESSION['csrf']))
            {
                $csrfFormToken = @(string) $_POST['csrf_token'];
                if($csrfFormToken === $_SESSION['csrf'])
                {
                    unset($_SESSION['csrf']);
                    return;
                }
            }

            http_response_code(401);
            echo 'CSRF-Token nicht gesetzt...';
            die();
        }
    }

    /**
     * @return mixed 
     * @throws Exception 
     */
    public function generateCSRFToken()
    {
        if(session_status() === PHP_SESSION_NONE)
        {
            session_start();
        }

        if(empty($_SESSION['csrf']))
        {
            $csrfToken = bin2hex(random_bytes(64));
            $_SESSION['csrf'] = $csrfToken;
        }
        return $_SESSION['csrf'];
    }
}